s                @                                      bp6706      Burster Digistant Type 6706                         Instrument Name: burster DIGISTANT Type 6706

  Description:   This instrument module provides
                 GPIB,RS232 and RS485(full duplex)
                 support for DIGISTANT Type 6706
                 from burster.

  Functions and Classes:

  (1) Initialize :
      Initialize the instrument and sets to
      default configuration

  (2) Configure:
      Configures the instrument by setting the
      range and protection mode

  (3) Set Voltage :
      Sets the voltage value of the DIGISTANT 6706

  (4) Get Voltage :
      Gets the voltage value of the DIGISTANT 6706

  (5) Set Current :
      Sets the current value of the DIGISTANT 6706

  (6) Get Current :
      Gets the current value of the DIGISTANT 6706

  (7) System:
      Reads the system error
      Reads the instrument ID-String
      Controls the keyboard
      Sends a SCPI-Message
      Receives a SCPI-Message

  (8) Clear Device :
      Clear the device.

  (9) Close :
      Takes the instrument off-line.
      *********
     ~     Class Name:    Initialize

 Description:   Sets up all necessary functions
                for initializing the Digistant.
    6     Panel Name:    Initialize Gpib

 Description:   Initializes the instrument by:
 1) finding an unused device in the device table
    using the supplied GPIB address
 2) device clear and RESET  (if desired)
 3) returns the ID-String of the instrument
 4) returns an instrument ID

 This is a multi-instrument driver, allowing
 multiple Digistant 6706 instruments to be
 controlled.
 During the initialization, the returned ID is
 based on the GPIB address.  This ID is used in
 all of the other functions to distinguish
 between multiple Digistant 6706 instruments.    ^     Panel Name:    Initialize Serial

 Description:   Initializes the instrument by:
 1) finding an unused device in the device table
    using the supplied serial group and user
    address
 2) device clear and RESET  (if desired)
 3) returns the ID-String of the instrument
 4) returns an instrument ID

 This is a multi-instrument driver, allowing
 multiple Digistant 6706 instruments to be
 controlled.
 During the initialization, the returned ID is
 based on the serial group and user address.
 This ID is used in all of the other functions
 to distinguish between multiple Digistant
 6706 instruments.     e     Panel Name:    Local (GPIB only)

 Description:   Sets the multimeter temporarily in
 local mode.
     y     Class Name:    Configure

 Description:   Sets up all necessary functions
                for Configure the Digistant.    ^     Panel Name:    Set Voltage Configure

 Description:   Configure the instrument in
                following ways:

                - Selects the voltage range of the
                  instrument
                - Switches the sense function
                  Internal/External
                - Input the current protection
                  level    W     Panel Name:    Gets Voltage Configure

 Description:   Configure the instrument in
                following ways:

                - Gets the voltage range of the
                  instrument
                - Gets the sense function
                  Internal/External
                - Gets the current protection
                  level         Panel Name:    Sets Current Configure

 Description:   Configure the instrument in
                following ways:

                - Selects the current range of the
                  instrument
                - Input the voltage protection
                  level
    	     Panel Name:    Gets Current Configure

 Description:   Configure the instrument in
                following ways:

                - Gets the current range of the
                  instrument
                - Gets the voltage protection
                  level     z     Class Name:    Output Values

 Description:   Sets up all necessary functions
                for output the Digistant.    ^     Panel Name:    Set Voltage Configure

 Description:   Configure the instrument in
                following ways:

                - Selects the voltage range of the
                  instrument
                - Switches the sense function
                  Internal/External
                - Input the current protection
                  level    W     Panel Name:    Gets Voltage Configure

 Description:   Configure the instrument in
                following ways:

                - Gets the voltage range of the
                  instrument
                - Gets the sense function
                  Internal/External
                - Gets the current protection
                  level         Panel Name:    Sets Current Configure

 Description:   Configure the instrument in
                following ways:

                - Selects the current range of the
                  instrument
                - Input the voltage protection
                  level
    	     Panel Name:    Gets Current Configure

 Description:   Configure the instrument in
                following ways:

                - Gets the current range of the
                  instrument
                - Gets the voltage protection
                  level     r     Class Name:    System

 Description:   Sets up all necessary system
                functions of the Digistant.     a     Panel Name:   System Error

 Description:  Reads the system error of the
               device     U     Panel Name:   System Keybroad

 Description:  Controls the keybroad of the device
     c     Panel Name:   Send a SCPI-Message

 Description:  Sends a SCPI-Message to a
               slave          Panel Name:   Receive a SCPI-Message

 Description:  Sends "Query form" from SCPI-
               Message and receive a answers
         Panel Name:    Close

 Description:   Takes the instrument off-line.

 Note: The  instrument must  be reinitialized
       to use it again.          Control Name:  Address

 Description:   Specifies the address on the GPIB
 to be used to communicate with the instrument.
 This value must correspond to the current
 internal setting of the instrument.

 Variable Type: Integer

 Valid Range:   0 to 30
          Control Name:  Reset

 Description:   If reset is on, a device clear and
 power on reset is done during initialization.

 Variable Type: Integer

 Valid Range:   0 to 1
 0  off
 1  on
          Control Name:  Instrument ID String

 Description:   Returns the ID-String of the
                instrument.

 Variable Type: String

    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid GPIB Address
 -2     Invalid Reset

 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator
     M            Address                            MN          Reset                                        Instrument ID-String               9          Instrument ID                     G          Error                              1   On 1 Off 0    	            	            	                Control Name:   COM-Port

 Description:    Specifies the COM-Port to be
                 used to communicate with the
                 instrument.

 Variable Type:  Integer

 Valid Values:   1 - COM1   (=> Adress 0x3f8 IRQ4)
                 2 - COM2   (=> Adress 0x2f8 IRQ3)
                 3 - COM3   (=> Adress 0x3e8 IRQ4)
                 4 - COM4   (=> Adress 0x2e8 IRQ3)

 Default:        1         Control Name:   Baud Rate

 Description:    Specifies the baud rate of the
                 RS232-Port to communicate with
                 the instrument. This value must
                 correspond to the current
                 internal setting of the
                 instrument.

 Variable Type:  Integer

 Valid Values:   1200,2400,4800,9600 or 19200 baud

 Default:        9600    *     Control Name:   Time-out (seconds)

 Description:    Specifies  the time-out limit for
                 I/O operations.
                 A  value  of  0.0  will  disable
                 time-out altogether.

 Variable Type:  Double

 Valid Range:    0.060 to 100.0 seconds

 Default:        1.0    q     Control Name:   Bcc-Check

 Description:    This parameter switches the block
                 check function of the driver ON
                 or OFF.
                 This value must correspond to the
                 current internal setting of the
                 instrument.

 Variable Type:  Integer

 Valid Values:   0 = OFF, 1 = ON

 Default:        0 = OFF    |     Control Name:  Group Address

 Description:   Specifies the group address on the
                RS232 (RS485) to be used to
                communicate with the instrument.
                This value must correspond to the
                current internal group address
                from the instrument.


 Variable Type: Integer

 Valid Range:   0 to 15

 Default:       0    w     Control Name:  User Adress

 Description:   Specifies the user address on the
                RS232 (RS485) to be used to
                communicate with the instrument.
                This value must correspond to the
                current internal user address
                from the instrument.

 Variable Type: Integer

 Valid Range:   0 to 15

 Default:       0          Control Name:  Instrument ID String

 Description:   Returns the ID-String of the
                instrument.

 Variable Type: String

    *     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.
          Control Name:  Reset

 Description:   If reset is on, a device clear and
 power on reset is done during initialization.

 Variable Type: Integer

 Valid Range:   0 to 1
                0 = off
                1 = on
         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   COM-Port is out of range
       -2   Baud Rate is out of range
       -3   Time-out is out of range
       -4   Block Check parameter is out of range
       -5   Group Address is out of range
       -6   User Address is out of range
       -7   Reset Device is out of range

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      9           COM-Port                           E           Baud Rate                         !          Time-out (seconds)                #           Block Check                       $|            Group Address                     &             User Address                      '          Instrument ID-String              (           Instrument ID                     )C 2          Reset                             *&          Error                                         1 1 2 2 3 3 4 4              41200 1200 2400 2400 4800 4800 9600 9600 19200 19200    1.0    On 1 Off 0    0    0    	            	           On 1 Off 0    	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.    	     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
  0     Success
 -1     Invalid Instrument ID

 220    Unable to open instrument
 221    Unable to close instrument
 224    Error clearing instrument
 230    Error writing to instrument
 231    Error reading from instrument
 232    Instrument not initialized
 233    Error configuring GPIB address
 236    Error interpreting instrument response
 237    Error configuring EOS terminator
    0             Instrument ID                     1          Error                              1    	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.    >     Control Name:  Range

 Description:   Specifices the range of the
                instrument .

 Variable Type: Integer

 Valid Range:   0 = Auto Range
                1 = 20  mV
                2 = 200 mV
                3 = 2   V
                4 = 20  V
                5 = 180 V

 Default Range: 0 = Auto Range    ]     Control Name:  Current Limit

 Description:   Specifices the current protection
                limit of all voltage ranges of the
                instrument .

 Variable Type: double

 Valid Range:   0.1mA-200mA (Voltage range
                                      20mV-20V)
                0.1mA-20mA (Voltage range 180V)

 Default Value: 20 mA         Control Name:  Voltage Sense

 Description:   Specifices the adjustment of the
                sense by output voltage.

 Variable Type: Integer

 Valid Range:   0 to 1
                0 = Internal Sense
                1 = External Sense


 Default Value: 0 = Internal Sense         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Range
       -4   Invalid Sense
       -3   Invalid Current Limit
  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

    4t             Instrument ID                     5 
          Voltage Range                     6 x         Current Limit [mA]                8P            Voltage Sense                     9n          Error                              1               -Auto 0 20 mV 1 200 mV 2 2 V 3 20 V 4 180 V 5    20    External 1 Internal 0    	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Voltage Range

 Description:   Displays the voltage range.

 Variable Type: Integer

                0 = Auto Range
                1 = 20  mV
                2 = 200 mV
                3 = 2   V
                4 = 20  V
                5 = 180 V

          Control Name:  Current Limit

 Description:   Displays the current protection
                limit of all voltage ranges of the
                instrument .

 Variable Type: double

 Value Unit:    mA          Control Name:  Voltage Sense

 Description:   Displays the adjustment of the
                sense by output voltage.

 Variable Type: Integer

                0 = Internal Sense
                1 = External Sense
         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT    >             Instrument ID                     ?9            Voltage Range                     @L          Current Limit [mA]                A             Voltage Sense                     B          Error                              1    	            	           	            	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Current Range

 Description:   Specifices the current range of
                the instrument .

 Variable Type: Integer

 Valid Range:   0 = Auto Range
                1 = 2   mA
                2 = 20  mA
                3 = 200 mA

 Default Range: 0 = Auto Range    3     Control Name:  Voltage Limit

 Description:   Specifices the voltage protection
                limit of all current ranges of the
                instrument .

 Variable Type: double

 Valid Range:   0.1V-180V (Current range 2mA-20mA)
                0.1V-20V  (Current range 200mA)

 Default Value: 20V         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Range
       -3   Invalid Limit

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT
    E             Instrument ID                     F 
          Current Range                     H          Voltage Limit [V]                 IU          Error                              1               Auto 0 2 mA 1 20 mA 2 200 mA 3    20    	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Current Range

 Description:   Displays the current range of
                the instrument .

 Variable Type: Integer

                0 = Auto Range
                1 = 2   mA
                2 = 20  mA
                3 = 200 mA          Control Name:  Voltage Limit

 Description:   Displays the voltage protection
                limit of all current ranges of the
                instrument .

 Variable Type: double

 Value Unit:    V
         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

    M*             Instrument ID                     N[            Current Range                     O\          Voltage Limit [V]                 P0          Error                              1    	            	           	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Voltage Value

 Description:   Specifices the voltage output
                value of the instrument .

 Variable Type: double
          Control Name:  Voltage Unit

 Description:   Specifices the voltage output
                unit of the instrument .

 Variable Type: Integer

                0 = uV
                1 = mV
                2 = V

 Default Value: 2 = V         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Invalid Unit

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      310   Device Voltage Error
      311   Device Current Error
      312   Device Over Error    S             Instrument ID                     T           Voltage Value                     U           Voltage Unit                      Vs          Error                              1    0              uV 0 mV 1 V 2    	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Voltage Value

 Description:   Displays the voltage output value.

 Variable Type: double

 Value Unit:    V
         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

    Zz             Instrument ID                     [           Voltage Value [V]                 \2          Error                              1    	           	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Current Value

 Description:   Specifices the current output
                value of the instrument .

 Variable Type: double
          Control Name:  Current Unit

 Description:   Specifices the current output
                unit of the instrument .

 Variable Type: Integer

                0 = uA
                1 = mV

 Default Value: 1 = mA         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Unit

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      310   Device Voltage Error
      311   Device Current Error
      312   Device Over Error    _w             Instrument ID                     `           Current Value                     aA           Current Unit                      b          Error                              1    0              
uA 0 mA 1    	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Current Value

 Description:   Displays the current output value.

 Variable Type: double

 Value Unit:    mA
         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT
    f#             Instrument ID                     gT           Current Value [mA]                g          Error                              1    	           	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  System Error

 Description:   Displays the SCPI system error


 Variable Type: String
                (see manual Resistomat Type 6706)
         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0     Success
       -1   Invalid Instrument ID

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT
    k              Instrument ID                     lQ m          System Error                      l          Error                              1    	            	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Keyboard

 Description:   This parameter locks the keyboard
                on the front panel of the
                instrument

 Variable Type: Integer

 Valid Range:   0  = Unlocked
                1  = Locked         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Value

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

    p9             Instrument ID                     qj m           Keyboard                          rX          Error                              1    Locked 1 Unlocked 0    	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Send SCPI-Message

 Description:   This control is a string parameter
                You must input the SCPI-message
                without the LineFeed termination.

 Example      : ":SENS:CORR:STATE ON"

 Variable Type: String
         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

    u             Instrument ID                     v }          Send-SCPI-Message                 w          Error                              1        	           )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Send SCPI-Message

 Description:   This control is a string parameter
                You must input Query-Form from
                the SCPI-message without the
                Line Feed termination.

 Example      : ":SENS:CORR:STATE?"

 Variable Type: String          Control Name:  Answer from Slave

 Description:   This control return a string from
                the slave.

 Variable Type: String (Length => see the 6706
                        Manual SCPI-Commands)         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT    {1             Instrument ID                     |b }          Send-SCPI-Message                 } }G         Instrument Answers                ~X          Error                              1        	            	           *     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.
         Control Name:  Error


 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID

      221   Unable to close instrument
      232   Instrument not initialized                 Instrument ID                               Error                              1    	                    m     K.    init_gpib                         A         - 
    K.    init_serial                       	         3     K.    local_gpib                        
         <     K.    set_volt_config                            D     K.    get_volt_config                   
Z         L     K.    set_curr_config                   p         R     K.    get_curr_config                            Ys     K.    set_volt_value                    i         ^     K.    get_volt_value                             e      K.    set_curr_value                             jd     K.    get_curr_value                    i         o}     K.    system_error                               t     K.    system_keyboard                   /         z}     K.    send_scpi                                       K.    receive_scpi                      %              K.    close                                                                      }Initialize                           DInitialize GPIB                      DInitialize Serial                    DLocal (GPIB only)                   
Configure                            DSets Voltage Configure               DGets Voltage Configure               DSets Current Configure               DGets Current Configure              Output Values                        DSets Voltage Value                   DGets Voltage Value                   DSets Current Value                   DGets Current Value                  System                               DSystem Error                         DSystem Keyboard                      DSend a SCPI-Message                  DReceive a SCPI-Message               DClose                           